<?php
/* --------------------------------------------------------------
 ChfEurUsdCurrencies.php 2020-01-22
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 22 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class ChfEurUsdCurrencies
 * @package Gambio\Core\Configuration\Types
 */
class ChfEurUsdCurrencies implements ConfigurationType
{
    private const CURRENCIES = [
        [
            'value' => 'CHF',
            'text'  => 'CHF',
        ],
        [
            'value' => 'EUR',
            'text'  => 'EUR',
        ],
        [
            'value' => 'USD',
            'text'  => 'USD',
        ],
    ];
    
    
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        return Options::fromArray(self::CURRENCIES);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}